/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.biz.dao.item.ItemStockManualChangeDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemStockManualChangeEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemStockManualChangeService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemStockManualChangeServiceImpl
implements ItemStockManualChangeService {
    @Resource
    private ItemStockManualChangeDao itemStockManualChangeDao;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;

    @Override
    @Transactional(value="credits")
    public boolean updateRemainingByEdit(Long appItemId, Integer preRemaining, Integer requiredRemaining) {
        if (preRemaining == null || requiredRemaining == null) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        int differRemaining = requiredRemaining - preRemaining;
        if (differRemaining == 0) {
            return true;
        }
        if (differRemaining > 0) {
            return this.addStockQuantity(appItemId, Math.abs(differRemaining));
        }
        if (differRemaining < 0) {
            return this.reduceStockQuantity(appItemId, Math.abs(differRemaining));
        }
        return false;
    }

    private boolean addStockQuantity(Long appItemId, Integer quantity) {
        AppItemEntity appItem = this.appItemService.find(appItemId);
        if (null == appItem) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        if (!appItem.getType().equals("object") && !appItem.getType().equals("virtual")) {
            throw new RuntimeGoodsException(ErrorCode.E0202008);
        }
        boolean result = this.appItemService.appendStock(appItem.getAppId(), appItemId, (long)quantity);
        if (!result) {
            throw new RuntimeGoodsException(ErrorCode.E0102002);
        }
        ItemStockManualChangeEntity itemStockChange = new ItemStockManualChangeEntity(true);
        itemStockChange.setRelationId(appItemId);
        itemStockChange.setRelationType("appItem");
        itemStockChange.setBeforeStock((long)appItem.getRemaining());
        itemStockChange.setAfterStock(Long.valueOf(appItem.getRemaining() + quantity));
        itemStockChange.setChangeKind("add");
        itemStockChange.setChangeQuantity((long)quantity);
        this.itemStockManualChangeDao.insert(itemStockChange);
        return true;
    }

    private boolean reduceStockQuantity(Long appItemId, Integer quantity) {
        AppItemEntity appItem = this.appItemService.find(appItemId);
        if (null == appItem) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        if (!appItem.getType().equals("object") && !appItem.getType().equals("virtual")) {
            throw new RuntimeGoodsException(ErrorCode.E0202008);
        }
        boolean result = this.appItemService.deductStock(appItem.getAppId(), appItemId, (long)quantity);
        if (!result) {
            throw new RuntimeGoodsException(ErrorCode.E0102002);
        }
        ItemStockManualChangeEntity itemStockChange = new ItemStockManualChangeEntity(true);
        itemStockChange.setRelationId(appItemId);
        itemStockChange.setRelationType("appItem");
        itemStockChange.setBeforeStock((long)appItem.getRemaining());
        itemStockChange.setAfterStock(Long.valueOf(appItem.getRemaining() - quantity));
        itemStockChange.setChangeKind("sub");
        itemStockChange.setChangeQuantity((long)quantity);
        this.itemStockManualChangeDao.insert(itemStockChange);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public boolean updateRemainingByEditItem(Long appItemId, Integer preRemaining, Integer requiredRemaining) {
        if (preRemaining == null || requiredRemaining == null) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        int differRemaining = requiredRemaining - preRemaining;
        if (differRemaining == 0) {
            return true;
        }
        if (differRemaining > 0) {
            return this.addStockQuantity_item(appItemId, Math.abs(differRemaining));
        }
        if (differRemaining < 0) {
            return this.reduceStockQuantity_item(appItemId, Math.abs(differRemaining));
        }
        return false;
    }

    private boolean addStockQuantity_item(Long itemId, Integer quantity) {
        ItemEntity item = this.itemService.find(itemId);
        if (null == item) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        if (!item.getType().equals("object") && !item.getType().equals("virtual")) {
            throw new RuntimeGoodsException(ErrorCode.E0202008);
        }
        boolean result = this.itemService.appendStock(itemId, (long)quantity);
        if (!result) {
            throw new RuntimeGoodsException(ErrorCode.E0102002);
        }
        ItemStockManualChangeEntity itemStockChange = new ItemStockManualChangeEntity(true);
        itemStockChange.setRelationId(itemId);
        itemStockChange.setRelationType("item");
        itemStockChange.setBeforeStock((long)item.getRemaining());
        itemStockChange.setAfterStock(Long.valueOf(item.getRemaining() + quantity));
        itemStockChange.setChangeKind("add");
        itemStockChange.setChangeQuantity((long)quantity);
        this.itemStockManualChangeDao.insert(itemStockChange);
        return true;
    }

    private boolean reduceStockQuantity_item(Long itemId, Integer quantity) {
        ItemEntity item = this.itemService.find(itemId);
        if (null == item) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        if (!item.getType().equals("object") && !item.getType().equals("virtual")) {
            throw new RuntimeGoodsException(ErrorCode.E0202008);
        }
        boolean result = this.itemService.deductStock(itemId, (long)quantity);
        if (!result) {
            throw new RuntimeGoodsException(ErrorCode.E0102002);
        }
        ItemStockManualChangeEntity itemStockChange = new ItemStockManualChangeEntity(true);
        itemStockChange.setRelationId(itemId);
        itemStockChange.setRelationType("item");
        itemStockChange.setBeforeStock((long)item.getRemaining());
        itemStockChange.setAfterStock(Long.valueOf(item.getRemaining() - quantity));
        itemStockChange.setChangeKind("sub");
        itemStockChange.setChangeQuantity((long)quantity);
        this.itemStockManualChangeDao.insert(itemStockChange);
        return true;
    }
}

