/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.stock.impl;

import cn.com.duiba.goods.center.biz.service.stock.MemStockService;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MemStockServiceImpl
implements MemStockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemStockServiceImpl.class);
    @Resource(name="stringRedisTemplate03")
    private RedisAtomicClient redisAtomicClient;

    @Override
    public boolean consumeEverydayStock(String key, Integer limitStock) {
        try {
            String stocKey = "everydayStock" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + key;
            Long value = this.redisAtomicClient.getLong(stocKey);
            if (value != null && value >= (long)limitStock.intValue()) {
                return false;
            }
            this.redisAtomicClient.incrBy(stocKey, 1L, 86400L, TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("consumeEverydayStock", (Throwable)e);
            return false;
        }
    }
}

