/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);

    private DateUtil() {
        throw new IllegalAccessError("Utility class");
    }

    private static SimpleDateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }

    public static Date getTodayZeroDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String getYYDayMinuteString(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtil.getStr(date, DateUtil.getFormat("yyMMddHHmmss"));
    }

    public static Date getDayDate(String dateStr) {
        return DateUtil.getDate(dateStr, DateUtil.getFormat("yyyy-MM-dd"));
    }

    private static Date getDate(String dateStr, SimpleDateFormat format) {
        if ("".equals(dateStr) || dateStr == null) {
            return null;
        }
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            LOGGER.error("format yyyy-MM-dd HH:mm:ss error:", (Throwable)e);
            return null;
        }
    }

    private static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getDayDate("2017-08-19"));
    }
}

