/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientUtil.class);
    private static HttpClient defaultClient = HttpClientUtil.createHttpClient(200, 20, 5000, 5000, 3000);

    public static HttpClient createHttpClient(int maxTotal, int maxPerRoute, int socketTimeout, int connectTimeout, int connectionRequestTimeout) {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(defaultRequestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(HttpClient httpClient, String url, Map<String, String> params, Charset encoding) {
        String resp = "";
        HttpPost httpPost = new HttpPost(url);
        if (params != null && params.size() > 0) {
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(formParams, encoding);
            httpPost.setEntity((HttpEntity)postEntity);
        }
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)httpPost);
            resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)encoding);
        }
        catch (IOException e) {
            LOG.warn("\u53d1\u9001post\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.warn("\u5173\u95edresponse\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return resp;
    }

    public static String sendPost(String url, Map<String, String> params) {
        Charset encoding = Charset.forName("utf8");
        return HttpClientUtil.sendPost(defaultClient, url, params, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostWithJSON(String url, JSONObject params) {
        String resp = "";
        HttpPost httpPost = new HttpPost(url);
        if (params != null && params.size() > 0) {
            StringEntity entity = new StringEntity(params.toJSONString(), Charset.forName("utf8"));
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
        }
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)defaultClient.execute((HttpUriRequest)httpPost);
            resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("utf8"));
        }
        catch (IOException e) {
            LOG.warn("\u53d1\u9001post\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.warn("\u5173\u95edresponse\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return resp;
    }
}

