/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.util;

import cn.com.duiba.wolf.utils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSA {
    public static final String RSA_SIGNATURE = "NONEwithRSA";
    private static final Logger LOG = LoggerFactory.getLogger(RSA.class);

    public static String sign(String content, String privateKey, String input_charset) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(SecurityUtils.decodeBase64((String)privateKey));
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(RSA_SIGNATURE);
            signature.initSign(priKey);
            signature.update(content.getBytes(input_charset));
            byte[] signed = signature.sign();
            return SecurityUtils.encode2StringByBase64((byte[])signed);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean verify(String content, String sign, String ali_public_key, String input_charset) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = SecurityUtils.decodeBase64((String)ali_public_key);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(RSA_SIGNATURE);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(input_charset));
            boolean bverify = signature.verify(SecurityUtils.decodeBase64((String)sign));
            return bverify;
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decrypt(String content, String private_key, String input_charset) {
        try {
            int bufl;
            PrivateKey prikey = RSA.getPrivateKey(private_key);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, prikey);
            ByteArrayInputStream ins = new ByteArrayInputStream(SecurityUtils.decodeBase64((String)content));
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            byte[] buf = new byte[128];
            while ((bufl = ins.read(buf)) != -1) {
                byte[] block = null;
                if (buf.length == bufl) {
                    block = buf;
                } else {
                    block = new byte[bufl];
                    for (int i = 0; i < bufl; ++i) {
                        block[i] = buf[i];
                    }
                }
                writer.write(cipher.doFinal(block));
            }
            return new String(writer.toByteArray(), input_charset);
        }
        catch (Exception e) {
            LOG.error("\u89e3\u5bc6\u5931\u8d25\uff0ccontent=" + content, (Throwable)e);
            return content;
        }
    }

    public static PrivateKey getPrivateKey(String key) {
        PrivateKey privateKey;
        byte[] keyBytes = SecurityUtils.decodeBase64((String)key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException("\u83b7\u53d6\u79c1\u94a5\u5931\u8d25", e);
        }
        return privateKey;
    }
}

