package cn.com.duiba.goods.center.common;

/**
 * 用于管理使用Memcached的所有key前缀，避免业务key重复<br/>
 * K001("xxx业务缓存"),<br/>
 * K002("xxx业务缓存"),<br/>
 * K003("xxx业务缓存");
 */
public enum MemcachedKeyFactory {

	/**
	 * IP地址数据缓存60s,
	 */
	K001("IP地址数据缓存")

	;

	/**
	 * 应用名称
	 */
	private static final String SPACE = "GC";

	private MemcachedKeyFactory(String description) {

	}

	/**
	 * 拼接key前置
	 */
	@Override
	public String toString() {
		return SPACE + "_" + super.toString() + "_";
	}

}