package cn.com.duiba.goods.common.dto;

import java.io.Serializable;

/**
 * 快递公司
 * Created by guoyanfei .
 * 2022/12/27 .
 */
public class ExpressCompany implements Serializable {

    private static final long serialVersionUID = -4876181596805622207L;

    /**
     * 公司名称，前端展示和传给后端都用这个字段
     */
    private String name;

    /**
     * 公司编码，前端不要用
     */
    private String code;

    /**
     * 公司类型，前端不要用
     * {@link cn.com.duiba.goods.common.enums.ExpressCompanyType}
     */
    private Integer type;

    public ExpressCompany() {
    }

    public ExpressCompany(String name, String code, Integer type) {
        this.name = name;
        this.code = code;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
