package cn.com.duiba.goods.common.enums;

import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 排序类型
 * Created by guoyanfei .
 * 2022/12/28 .
 */
public enum ScrollingType implements BaseEnum {

    DESC(1, "倒序"),
    ASC(2, "升序");

    private final int code;

    private final String desc;

    ScrollingType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static ScrollingType getByCode(int code) {
        for (ScrollingType it : ScrollingType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "ScrollingType");
    }

}
