package cn.com.duiba.goods.common.enums.goods;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 收货信息类型
 * Created by guoyanfei .
 * 2023/1/10 .
 */
public enum AccountType implements BaseEnum {

    MOBILE(1, "手机号"),
    NAME(2, "姓名"),
    QQ(3, "QQ号"),
    EMAIL(4, "邮箱"),
    CUSTOMIZE(5, "会员账号");

    private final int code;

    private final String desc;

    AccountType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static AccountType getByCode(int code) {
        for (AccountType it : AccountType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "AccountType");
    }

}
