package cn.com.duiba.goods.common.enums.goods;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 商品状态
 * Created by guoyanfei .
 * 2022/11/14 .
 */
public enum SpuState implements BaseEnum {

    BEFORE_AUDIT(1, "待提审"),
    AUDITING(2, "审核中"),
    INSTORE(3, "已入库");

    private final int code;

    private final String desc;

    SpuState(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static SpuState getByCode(int code) {
        for (SpuState it : SpuState.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "SpuState");
    }

}
