package cn.com.duiba.goods.common.enums.order;

import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 售后历史中，不同状态的名字
 * Created by guoyanfei .
 * 2022/12/22 .
 */
public enum RefundOp {

    OP1(1, "买家售后待审核"),
    OP2(2, "商家审核通过"),
    OP3(3, "商家审核拒绝"),
    OP4(4, "买家上传单号"),
    OP5(5, "商家确认收货, 同意退款"),
    OP6(6, "买家取消售后");

    private int value;

    private String name;

    RefundOp(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public int getValue() {
        return value;
    }

    public static RefundOp get(RefundOrderStatus refundOrderStatus, RefundType refundType) {
        switch (refundOrderStatus) {
            case CREATED:
                return OP1;
            case UNSHIPPED:
                return OP2;
            case SHIPPED:
                return OP4;
            case COMPLETED:
                switch (refundType) {
                    case ONLY_REFUND:
                        return OP2;
                    case RETURN_AND_REFUND:
                        return OP5;
                }
            case REJECTED:
                return OP3;
            case CANCELED:
                return OP6;
        }
        throw new EnumNotFoundException("RefundOpName not exist, refundOrderStatus={}, refundType={}", refundOrderStatus, refundType);
    }
}
