package cn.com.duiba.goods.common.enums.order;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 供应商订单表的 orderStatus 字段枚举
 * @date 2023/2/21
 * @author guoyanfei
 */
public enum SupplierOrderStatus implements BaseEnum {

    CREATED(0, "创建"),
    IN_PROCESS(1, "处理中"),
    SUCCEED(2, "成功"),
    FAILED(3, "失败"),
    EXCEPTION(4, "异常"),
    CANCELED(5, "取消");

    private final int code;

    private final String desc;

    SupplierOrderStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static SupplierOrderStatus getByCode(int code) {
        for (SupplierOrderStatus it : SupplierOrderStatus.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "SupplierOrderStatus");
    }
}
