package cn.com.duiba.goods.common.enums.supplier;

import cn.com.duiba.goods.common.enums.goods.SpuType;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 虚拟商品供应商code枚举
 * 2023/2/9 .
 * @author guoyanfei
 */
@Getter
@AllArgsConstructor
public enum VirtualSupplierCodeEnum {

    WX_FAVOR("wx_favor", "微信代金券-废弃", SpuType.WX_COUPON, false),
    WX_FAVOR_ZY("wx_favor_zy", "微信立减金", SpuType.WX_COUPON, true),
    ALIPAY_COUPON_CARD("alipay_coupon_card", "支付宝立减金", SpuType.ALIPAY_COUPON, true),
    I_QI_YI_ZC("i_qi_yi_zc", "爱奇艺直充", SpuType.I_QI_YI_ZC, true),
    ALI_PAY_COUNT_COINS("alipay_count_coins", "支付宝数币红包", SpuType.ALI_PAY_COUNT_COINS, true),
    CCB_PAY_COUNT_COINS("ccb_count_coins", "建行数币红包", SpuType.CCB_COUNT_COINS, true),
    ;

    private final String code;
    private final String desc;
    private final SpuType spuType;
    private final boolean canSelect;

    public static VirtualSupplierCodeEnum getByCode(String code) {
        for (VirtualSupplierCodeEnum it : VirtualSupplierCodeEnum.values()) {
            if (it.getCode().equals(code)) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "VirtualSupplierCodeEnum");
    }
}
