package cn.com.duiba.goods.common.enums.stock;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 库存的 sourceType 字段枚举
 * Created by guoyanfei .
 * 2022/11/7 .
 */
public enum StockSourceType implements BaseEnum {

    SHARED_SKU(1, "共享SKU库存"),
    PRE_ALLOCATED_SKU(2, "预分配SKU库存");

    private final int code;

    private final String desc;

    StockSourceType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static StockSourceType getByCode(int code) {
        for (StockSourceType it : StockSourceType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "StockSourceType");
    }

}
