package cn.com.duiba.goods.common.dto;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * SKU的规格
 * Created by guoyanfei .
 * 2022/11/15 .
 */
public class AttrValue implements Serializable {

    private static final String SEPARATOR = "#@#";

    private static final long serialVersionUID = 7942691214665190657L;

    /**
     * 属性key的id，如果是自定义，那么为0
     */
    private Long key;

    /**
     * 属性key的别名，如：内存
     */
    private String keyAlias;

    /**
     * 属性val的id，如果是自定义，那么为0
     */
    private Long val;

    /**
     * 属性val的别名，如：128G
     */
    private String valAlias;

    /**
     * SKU的批量设置图片
     */
    private String img;

    /**
     * 获取key和keyAlias的组合key
     * @return
     */
    @JSONField(serialize = false)
    public String getUnionKey() {
        return key + SEPARATOR + keyAlias;
    }

    public Long getKey() {
        return key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public String getKeyAlias() {
        return keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public Long getVal() {
        return val;
    }

    public void setVal(Long val) {
        this.val = val;
    }

    public String getValAlias() {
        return valAlias;
    }

    public void setValAlias(String valAlias) {
        this.valAlias = valAlias;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }
}
