package cn.com.duiba.goods.common.enums;

import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 启动禁用枚举
 * Created by guoyanfei .
 * 2022/11/7 .
 */
public enum EnabledEnum implements BaseEnum {

    DISABLED(0, "禁用"),
    ENABLED(1, "启用");

    private final int code;

    private final String desc;

    EnabledEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static EnabledEnum getByCode(int code) {
        for (EnabledEnum it : EnabledEnum.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "EnabledEnum");
    }

}
