package cn.com.duiba.goods.common.enums.goods;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * SPU类型枚举
 * Created by guoyanfei .
 * 2022/11/14 .
 */
public enum SpuType implements BaseEnum {

    OBJECT(1, "实物"),
    VIRTUAL(2, "虚拟");

    private final int code;

    private final String desc;

    SpuType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static SpuType getByCode(int code) {
        for (SpuType it : SpuType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "SpuType");
    }

}
