package cn.com.duiba.goods.common.enums.order;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 售后订单表的 refundOrderStatus 字段枚举
 * Created by guoyanfei .
 * 2022/12/14 .
 */
public enum RefundOrderStatus implements BaseEnum {

    CREATED(0, "等待审核"),
    UNSHIPPED(1, "等待买家上传单号"),
    SHIPPED(2, "买家退货待确认"),
    COMPLETED(3, "已同意退款"),
    REJECTED(4, "拒绝售后申请"),
    CANCELED(5, "买家取消售后");

    private final int code;

    private final String desc;

    RefundOrderStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static RefundOrderStatus getByCode(int code) {
        for (RefundOrderStatus it : RefundOrderStatus.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "RefundOrderStatus");
    }
}
