package cn.com.duiba.goods.inner.api.autoconfig.excel;

import cn.com.duiba.goods.common.dto.ScrollingPageRequest;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * excel分页查询
 * Created by guoyanfei .
 * 2022/12/28 .
 */
public interface ExcelPageQuery<P extends ScrollingPageRequest, R> {

    /**
     * 查分页数据
     *
     * @param param
     * @return left: 数据结果集, right: 边界值
     */
    Pair<List<R>, Long> findPage(P param);

    /**
     * 获取标题行的class
     *
     * @return
     */
    Class<R> getHeaderClass();

}
