package cn.com.duiba.goods.inner.api.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 批量发货参数
 * Created by guoyanfei .
 * 2022/12/26 .
 */
@Data
public abstract class BaseBatchShipDTO implements Serializable {

    private static final long serialVersionUID = -1384621722779249368L;

    /**
     * 订单号
     */
    @NotBlank(message = "【订单号】不能为空")
    private String orderNo;

    /**
     * 商品类型
     * @see cn.com.duiba.goods.common.enums.goods.SpuType
     */
    public Integer spuType;

}
