package cn.com.duiba.goods.inner.api.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 订单发货包装实体
 * Created by guoyanfei .
 * 2022/12/19 .
 */
@Data
public abstract class BaseOrderShipDTO implements Serializable {

    private static final long serialVersionUID = 770165113201830878L;

    /**
     * 订单号
     */
    @NotBlank(message = "【订单号】不能为空")
    private String orderNo;

    /**
     * 供应商id
     */
    @NotNull(message = "【供应商id】不能为空")
    private Long supplierId;

    /**
     * 商品类型
     * @see cn.com.duiba.goods.common.enums.goods.SpuType
     */
    public Integer spuType;
}
