package cn.com.duiba.goods.inner.api.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * 实物批量发货参数
 * Created by guoyanfei .
 * 2023/1/11 .
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ObjectBatchShipDTO extends BaseBatchShipDTO {

    private static final long serialVersionUID = 6484463779800818239L;

    /**
     * 发货物流公司
     */
    @NotBlank(message = "【发货物流公司】不能为空")
    private String deliveryExpressCompany;

    /**
     * 物流单号
     */
    @NotBlank(message = "【物流单号】不能为空")
    private String trackingNumber;
}
