package cn.com.duiba.goods.inner.api.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * 实物订单发货参数
 * Created by guoyanfei .
 * 2023/1/11 .
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ObjectOrderShipDTO extends BaseOrderShipDTO {

    private static final long serialVersionUID = 7115430621400050438L;

    /**
     * 发货物流公司
     */
    @NotBlank(message = "【发货物流公司】不能为空")
    private String deliveryExpressCompany;

    /**
     * 物流单号
     */
    @NotBlank(message = "【物流单号】不能为空")
    private String trackingNumber;
}
