package cn.com.duiba.goods.inner.api.dto;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 供应商确认收到退货请求参数
 * Created by guoyanfei .
 * 2022/12/20 .
 */
public class RefundCompleteDTO implements Serializable {

    private static final long serialVersionUID = -4042412827188625898L;

    /**
     * 售后订单号
     */
    @NotBlank(message = "【售后订单号】不能为空")
    private String refundOrderNo;

    /**
     * 供应商id
     */
    @NotNull(message = "【供应商id】不能为空")
    private Long supplierId;

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
}
