package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.goods.common.dto.ScrollingPageRequest;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 待发货滚动分页查询
 * Created by guoyanfei .
 * 2022/12/28 .
 */
public class UnshippedOrderScrollingSearchDTO extends ScrollingPageRequest {

    private static final long serialVersionUID = 2373775203353141838L;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * 进入待发货时间 开始 格式 yyyy-MM-dd HH:mm:ss
     */
    private Date unshippedGmtCreateStart;

    /**
     * 进入待发货时间 结束 格式 yyyy-MM-dd HH:mm:ss
     */
    private Date unshippedGmtCreateEnd;

    /**
     * 客户id（所属业务）具体见 /s/customer/list 接口
     */
    private Long customerId;

    /**
     * 商品类型，1实物，2微信立减金
     * {@link cn.com.duiba.goods.common.enums.goods.SpuType}
     */
    private Integer spuType;

    /**
     * 供应商id
     */
    @NotNull(message = "【供应商id】不能为null")
    private Long supplierId;

    public Integer getSpuType() {
        return spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getUnshippedGmtCreateStart() {
        return unshippedGmtCreateStart;
    }

    public void setUnshippedGmtCreateStart(Date unshippedGmtCreateStart) {
        this.unshippedGmtCreateStart = unshippedGmtCreateStart;
    }

    public Date getUnshippedGmtCreateEnd() {
        return unshippedGmtCreateEnd;
    }

    public void setUnshippedGmtCreateEnd(Date unshippedGmtCreateEnd) {
        this.unshippedGmtCreateEnd = unshippedGmtCreateEnd;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
}
