package cn.com.duiba.goods.inner.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.inner.api.dto.AttrDTO;
import cn.com.duiba.goods.inner.api.dto.AttrValDTO;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 属性相关RPC服务
 * Created by guoyanfei .
 * 2022/11/18 .
 */
@Validated
@AdvancedFeignClient
public interface RemoteAttrService {

    /**
     * 根据关键字模糊匹配属性
     *
     * @param query 关键字
     * @return 属性list
     */
    List<AttrDTO> list(String query);

    /**
     * 根据关键字模糊匹配某个属性的属性值
     *
     * @param attrId 属性id
     * @param query  关键字
     * @return 属性值list
     */
    List<AttrValDTO> listVals(@NotNull(message = "【属性id】不能为null") Long attrId, String query);
}
