package cn.com.duiba.goods.inner.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.inner.api.dto.SupplierDto;
import cn.com.duiba.wolf.entity.PageRequest;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 供应商相关RPC接口
 * Created by guoyanfei .
 * 2022/10/20 .
 */
@AdvancedFeignClient
public interface RemoteSupplierService {

    /**
     * 根据【供应商id】获取供应商，包含禁用
     * @param id 供应商id
     * @return 供应商信息(不包含密码)
     */
    SupplierDto get(Long id) throws BizException;

    /**
     * 查询供应商分页list
     * @param request 分页参数
     * @return 供应商信息分页结果
     */
    PageResponse<SupplierDto> page(PageRequest request);

    /**
     * 保存供应商信息
     * @param supplier 供应商信息
     * @return 返回变更的供应商id
     */
    Long save(SupplierDto supplier) throws BizException;

    /**
     * 根据【供应商id】获取密码
     * @param id 供应商id
     * @return 供应商密码
     */
    String getPasswd(Long id) throws BizException;

    /**
     * 根据【供应商id】重置密码
     * @param id 供应商id
     */
    void resetPasswd(Long id) throws BizException;
}
