package cn.com.duiba.goods.inner.api.autoconfig;

import cn.com.duiba.goods.inner.api.autoconfig.excel.EasyExcelComponent;
import com.alibaba.excel.EasyExcelFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 自动装配相关配置
 * Created by guoyanfei .
 * 2022/12/27 .
 */
@Configuration
public class GoodsInnerAutoConfiguration {

    /**
     * excel相关配置
     */
    @Configuration
    @ConditionalOnClass({ EasyExcelFactory.class, })
    public static class EasyExcelConfiguration {

        @Bean
        public EasyExcelComponent easyExcelComponent() {
            return new EasyExcelComponent();
        }
    }

}
