package cn.com.duiba.goods.inner.api.dto;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 批量发货参数
 * Created by guoyanfei .
 * 2022/12/26 .
 */
public abstract class BaseBatchShipDTO implements Serializable {

    private static final long serialVersionUID = -1384621722779249368L;

    /**
     * 订单号
     */
    @NotBlank(message = "【订单号】不能为空")
    private String orderNo;

    public abstract Integer getSpuType();

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

}
