package cn.com.duiba.goods.inner.api.dto;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 订单发货包装实体
 * Created by guoyanfei .
 * 2022/12/19 .
 */
public abstract class BaseOrderShipDTO implements Serializable {

    private static final long serialVersionUID = 770165113201830878L;

    /**
     * 订单号
     */
    @NotBlank(message = "【订单号】不能为空")
    private String orderNo;

    /**
     * 供应商id
     */
    @NotNull(message = "【供应商id】不能为空")
    private Long supplierId;

    public abstract Integer getSpuType();

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
}
