package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.goods.common.enums.order.ShippedError;

import java.io.Serializable;

/**
 * 批量发货结果
 * Created by guoyanfei .
 * 2023/1/11 .
 */
public class BatchShipResultDTO<T extends BaseBatchShipDTO> implements Serializable {

    private static final long serialVersionUID = -3223420542853830335L;

    /**
     * 批量发货参数
     */
    private T dto;

    /**
     * 结果
     */
    private boolean success;

    /**
     * 额外信息
     */
    private String msg;

    public BatchShipResultDTO() {
    }

    public static <T extends BaseBatchShipDTO> BatchShipResultDTO success(T dto) {
        return new BatchShipResultDTO(dto, true, null);
    }

    public static <T extends BaseBatchShipDTO> BatchShipResultDTO fail(T dto, ShippedError error) {
        return new BatchShipResultDTO(dto, false, error.getDesc());
    }

    public T getDto() {
        return dto;
    }

    public void setDto(T dto) {
        this.dto = dto;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public BatchShipResultDTO(T dto, boolean success, String msg) {
        this.dto = dto;
        this.success = success;
        this.msg = msg;
    }
}
