package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 批量发货记录展示实体
 * Created by guoyanfei .
 * 2022/12/14 .
 */
public class BatchShippedRecordDTO implements Serializable {

    private static final long serialVersionUID = -3064391399526460414L;

    /**
     * 文件名称
     */
    private String batchFileName;

    /**
     * 下单时间
     */
    private Date gmtCreate;

    /**
     * 成功数量
     */
    private Integer successCount;

    /**
     * 失败数量
     */
    private Integer failCount;

    /**
     * 原始表格
     */
    private String originFile;

    /**
     * 失败表格
     */
    private String failFile;

    /**
     * 商品类型
     * {@link cn.com.duiba.goods.common.enums.goods.SpuType}
     */
    private Integer spuType;

    public Integer getSpuType() {
        return spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getBatchFileName() {
        return batchFileName;
    }

    public void setBatchFileName(String batchFileName) {
        this.batchFileName = batchFileName;
    }

    public Integer getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(Integer successCount) {
        this.successCount = successCount;
    }

    public Integer getFailCount() {
        return failCount;
    }

    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }

    public String getOriginFile() {
        return originFile;
    }

    public void setOriginFile(String originFile) {
        this.originFile = originFile;
    }

    public String getFailFile() {
        return failFile;
    }

    public void setFailFile(String failFile) {
        this.failFile = failFile;
    }
}
