package cn.com.duiba.goods.inner.api.dto;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 批量发货记录保存参数
 * Created by guoyanfei .
 * 2022/12/27 .
 */
public class BatchShippedRecordSaveDTO implements Serializable {

    private static final long serialVersionUID = -6533361815853864062L;

    /**
     * 供应商id
     */
    @NotNull(message = "【供应商id】不能为空")
    private Long supplierId;

    /**
     * 文件名称
     */
    @NotBlank(message = "【文件名称】不能为空")
    private String batchFileName;

    /**
     * 成功数量
     */
    @NotNull(message = "【成功数量】不能为空")
    private Integer successCount;

    /**
     * 失败数量
     */
    @NotNull(message = "【失败数量】不能为空")
    private Integer failCount;

    /**
     * 原始表格
     */
    @NotBlank(message = "【原始表格】不能为空")
    private String originFile;

    /**
     * 失败表格
     */
    private String failFile;

    /**
     * 商品类型
     * {@link cn.com.duiba.goods.common.enums.goods.SpuType}
     */
    @NotNull(message = "【发货商品类型】不能为空")
    private Integer spuType;

    public Integer getSpuType() {
        return spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getBatchFileName() {
        return batchFileName;
    }

    public void setBatchFileName(String batchFileName) {
        this.batchFileName = batchFileName;
    }

    public Integer getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(Integer successCount) {
        this.successCount = successCount;
    }

    public Integer getFailCount() {
        return failCount;
    }

    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }

    public String getOriginFile() {
        return originFile;
    }

    public void setOriginFile(String originFile) {
        this.originFile = originFile;
    }

    public String getFailFile() {
        return failFile;
    }

    public void setFailFile(String failFile) {
        this.failFile = failFile;
    }
}
