package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户信息DTO(包含secret)
 * Created by guoyanfei .
 * 2022/11/18 .
 */
public class CustomerWithSecretDTO implements Serializable {

    private static final long serialVersionUID = -254871864446282668L;

    /**
     * 客户id
     */
    private Long id;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 是否启用，1启用，0禁用
     * {@link cn.com.duiba.goods.common.enums.EnabledEnum}
     */
    private Integer enabled;

    /**
     * 调用api所需的key
     */
    private String apiKey;

    /**
     * 签名用的密钥，明文
     */
    private String apiSecretPlaintext;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 记录最近更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiSecretPlaintext() {
        return apiSecretPlaintext;
    }

    public void setApiSecretPlaintext(String apiSecretPlaintext) {
        this.apiSecretPlaintext = apiSecretPlaintext;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
