package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.goods.common.enums.goods.SpuType;

import javax.validation.constraints.NotBlank;

/**
 * 实物批量发货参数
 * Created by guoyanfei .
 * 2023/1/11 .
 */
public class ObjectBatchShipDTO extends BaseBatchShipDTO {

    private static final long serialVersionUID = 6484463779800818239L;

    /**
     * 发货物流公司
     */
    @NotBlank(message = "【发货物流公司】不能为空")
    private String deliveryExpressCompany;

    /**
     * 物流单号
     */
    @NotBlank(message = "【物流单号】不能为空")
    private String trackingNumber;

    @Override
    public Integer getSpuType() {
        return SpuType.OBJECT.code();
    }

    public String getDeliveryExpressCompany() {
        return deliveryExpressCompany;
    }

    public void setDeliveryExpressCompany(String deliveryExpressCompany) {
        this.deliveryExpressCompany = deliveryExpressCompany;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }
}
