package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单导出实体
 * Created by guoyanfei .
 * 2022/12/27 .
 */
public class OrderExportDTO implements Serializable {

    private static final long serialVersionUID = -4666467817401410841L;

    private Long id;

    /**
     * 所属业务
     * 通过 customerId 关联
     */
    private String customerName;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 下单时间
     */
    private Date gmtCreate;

    /**
     * 供货价快照，单位分，比如1元，数据存为100
     * 通过 snapshotSupplyPrice 计算
     */
    private String showSnapshotSupplyPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 备注，买家留言
     */
    private String remark;

    /**
     * 订单状态
     * 通过 orderStatus 转换
     */
    private String showOrderStatus;

    /**
     * 售后状态
     * 通过 refundOrderStatus 转换
     */
    private String showRefundOrderStatus;

    /**
     * 商品名称
     */
    private String snapshotSpuName;

    /**
     * 商品规格
     */
    private String snapshotAttrs;

    /**
     * 商品类型
     * {@link cn.com.duiba.goods.common.enums.goods.SpuType}
     */
    private String showSpuType;

    /**
     * 商品id
     */
    private String spuCode;

    /**
     * 规格编码
     */
    private String supplierSkuCode;

    /**
     * 收货人姓名
     */
    private String buyerName;

    /**
     * 收货人手机号
     */
    private String buyerTel;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区（县）
     */
    private String district;

    /**
     * 街道（镇）
     */
    private String street;

    /**
     * 详细地址
     */
    private String addrDetail;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 税率，比如16%，那么存储1600
     */
    private String showSnapshotTaxRate;

    /**
     * 发货物流公司
     */
    private String deliveryExpressCompany;

    /**
     * 物流单号
     */
    private String trackingNumber;

    /**
     * 虚拟商品订单收货信息
     */
    private String accountInfo;

    public String getAccountInfo() {
        return accountInfo;
    }

    public void setAccountInfo(String accountInfo) {
        this.accountInfo = accountInfo;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getShowSnapshotTaxRate() {
        return showSnapshotTaxRate;
    }

    public void setShowSnapshotTaxRate(String showSnapshotTaxRate) {
        this.showSnapshotTaxRate = showSnapshotTaxRate;
    }

    public String getDeliveryExpressCompany() {
        return deliveryExpressCompany;
    }

    public void setDeliveryExpressCompany(String deliveryExpressCompany) {
        this.deliveryExpressCompany = deliveryExpressCompany;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getShowSnapshotSupplyPrice() {
        return showSnapshotSupplyPrice;
    }

    public void setShowSnapshotSupplyPrice(String showSnapshotSupplyPrice) {
        this.showSnapshotSupplyPrice = showSnapshotSupplyPrice;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getShowOrderStatus() {
        return showOrderStatus;
    }

    public void setShowOrderStatus(String showOrderStatus) {
        this.showOrderStatus = showOrderStatus;
    }

    public String getShowRefundOrderStatus() {
        return showRefundOrderStatus;
    }

    public void setShowRefundOrderStatus(String showRefundOrderStatus) {
        this.showRefundOrderStatus = showRefundOrderStatus;
    }

    public String getSnapshotSpuName() {
        return snapshotSpuName;
    }

    public void setSnapshotSpuName(String snapshotSpuName) {
        this.snapshotSpuName = snapshotSpuName;
    }

    public String getSnapshotAttrs() {
        return snapshotAttrs;
    }

    public void setSnapshotAttrs(String snapshotAttrs) {
        this.snapshotAttrs = snapshotAttrs;
    }

    public String getSpuCode() {
        return spuCode;
    }

    public void setSpuCode(String spuCode) {
        this.spuCode = spuCode;
    }

    public String getSupplierSkuCode() {
        return supplierSkuCode;
    }

    public void setSupplierSkuCode(String supplierSkuCode) {
        this.supplierSkuCode = supplierSkuCode;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getBuyerTel() {
        return buyerTel;
    }

    public void setBuyerTel(String buyerTel) {
        this.buyerTel = buyerTel;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getAddrDetail() {
        return addrDetail;
    }

    public void setAddrDetail(String addrDetail) {
        this.addrDetail = addrDetail;
    }

    public String getShowSpuType() {
        return showSpuType;
    }

    public void setShowSpuType(String showSpuType) {
        this.showSpuType = showSpuType;
    }
}
