package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.wolf.entity.PageRequest;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 全部订单分页筛选条件
 * Created by guoyanfei .
 * 2022/12/14 .
 */
public class OrderListSearchDTO extends PageRequest {

    private static final long serialVersionUID = 2701470431466449234L;

    /**
     * 商品ID
     */
    private String spuCode;

    /**
     * 订单状态
     * {@link cn.com.duiba.goods.common.enums.order.OrderStatus}
     */
    private Integer orderStatus;

    /**
     * 供应商的规格编码
     */
    private String supplierSkuCode;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * 下单时间 开始 格式 yyyy-MM-dd HH:mm:ss
     */
    private Date gmtCreateStart;

    /**
     * 下单时间 结束 格式 yyyy-MM-dd HH:mm:ss
     */
    private Date gmtCreateEnd;

    /**
     * 买家姓名
     */
    private String buyerName;

    /**
     * 买家手机号
     */
    private String buyerTel;

    /**
     * 客户id（所属业务）具体见 /s/customer/list 接口
     */
    private Long customerId;

    /**
     * 发货时间 开始 格式 yyyy-MM-dd HH:mm:ss
     */
    private Date shippedTimeStart;

    /**
     * 发货时间 结束 格式 yyyy-MM-dd HH:mm:ss
     */
    private Date shippedTimeEnd;

    /**
     * 供应商id
     */
    @NotNull(message = "【供应商id】不能为空")
    private Long supplierId;

    /**
     * 商品类型，1实物，2虚拟
     * {@link cn.com.duiba.goods.common.enums.goods.SpuType}
     */
    private Integer spuType;

    public Integer getSpuType() {
        return spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSpuCode() {
        return spuCode;
    }

    public void setSpuCode(String spuCode) {
        this.spuCode = spuCode;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getSupplierSkuCode() {
        return supplierSkuCode;
    }

    public void setSupplierSkuCode(String supplierSkuCode) {
        this.supplierSkuCode = supplierSkuCode;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getGmtCreateStart() {
        return gmtCreateStart;
    }

    public void setGmtCreateStart(Date gmtCreateStart) {
        this.gmtCreateStart = gmtCreateStart;
    }

    public Date getGmtCreateEnd() {
        return gmtCreateEnd;
    }

    public void setGmtCreateEnd(Date gmtCreateEnd) {
        this.gmtCreateEnd = gmtCreateEnd;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getBuyerTel() {
        return buyerTel;
    }

    public void setBuyerTel(String buyerTel) {
        this.buyerTel = buyerTel;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Date getShippedTimeStart() {
        return shippedTimeStart;
    }

    public void setShippedTimeStart(Date shippedTimeStart) {
        this.shippedTimeStart = shippedTimeStart;
    }

    public Date getShippedTimeEnd() {
        return shippedTimeEnd;
    }

    public void setShippedTimeEnd(Date shippedTimeEnd) {
        this.shippedTimeEnd = shippedTimeEnd;
    }
}
