package cn.com.duiba.goods.inner.api.dto;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 售后单同意售后包装实体
 * Created by guoyanfei .
 * 2022/12/19 .
 */
public class RefundAcceptDTO implements Serializable {

    private static final long serialVersionUID = -1409000143550351688L;

    /**
     * 售后订单号
     */
    @NotBlank(message = "【售后订单号】不能为空")
    private String refundOrderNo;

    /**
     * 供应商id
     */
    @NotNull(message = "【供应商id】不能为空")
    private Long supplierId;

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
}
