package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.goods.common.enums.goods.SpuType;

import javax.validation.constraints.NotBlank;

/**
 * 虚拟商品订单发货参数
 * Created by guoyanfei .
 * 2023/1/11 .
 */
public class VirtualOrderShipDTO extends BaseOrderShipDTO {

    private static final long serialVersionUID = -2155090009720819961L;

    /**
     * 兑换内容
     */
    @NotBlank(message = "兑换内容不能为空")
    private String goodsInfo;

    @Override
    public Integer getSpuType() {
        return SpuType.VIRTUAL.code();
    }

    public String getGoodsInfo() {
        return goodsInfo;
    }

    public void setGoodsInfo(String goodsInfo) {
        this.goodsInfo = goodsInfo;
    }
}
