package cn.com.duiba.goods.inner.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.inner.api.dto.*;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 订单相关服务
 * Created by guoyanfei .
 * 2022/12/19 .
 */
@AdvancedFeignClient
public interface RemoteOrderService {

    /**
     * 分页查询
     *
     * @param dto
     * @return
     */
    PageResponse<OrderListDTO> page(@Valid OrderListSearchDTO dto);

    /**
     * 导出查询单页数据
     *
     * @param dto
     * @return
     */
    List<OrderExportDTO> exportPage(@Valid OrderScrollingSearchDTO dto);

    /**
     * 查询单条
     *
     * @param supplierId
     * @param orderNo
     * @return
     */
    OrderDetailDTO get(@NotNull(message = "【供应商id】不能为空") Long supplierId, @NotBlank(message = "【订单号】不能为空") String orderNo) throws BizException;
}
