package cn.com.duiba.goods.inner.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.inner.api.dto.*;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 售后订单相关服务
 * Created by guoyanfei .
 * 2022/12/19 .
 */
@AdvancedFeignClient
public interface RemoteRefundOrderService {

    /**
     * 同意售后
     *
     * @param dto
     */
    void accept(@Valid RefundAcceptDTO dto) throws BizException;

    /**
     * 拒绝售后
     *
     * @param dto
     */
    void reject(@Valid RefundRejectDTO dto) throws BizException;

    /**
     * 完成售后（供应商确认收到退货）
     *
     * @param dto
     */
    void complete(@Valid RefundCompleteDTO dto) throws BizException;

    /**
     * 分页查列表
     *
     * @param dto
     * @return
     */
    PageResponse<RefundOrderListDTO> page(@Valid RefundOrderListSearchDTO dto);

    /**
     * 查售后订单数量
     *
     * @param supplierId
     * @return
     */
    Integer count(@NotNull(message = "【供应商id】不能为空") Long supplierId);
}
