package cn.com.duiba.hdtool.center.api.dto.hdtool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

import static cn.com.duiba.hdtool.center.api.enums.UploadImageEnum.BANNER_IMAGE_NEW;
import static cn.com.duiba.hdtool.center.api.enums.UploadImageEnum.SMALL_IMAGE_NEW;

public class DuibaHdtoolDto implements Serializable {

    private static final long serialVersionUID = -1692595446834739092L;
    public static final int STATUS_NOCOMPLETE = 0; // 数据不完整
    public static final int STATUS_OPEN = 1; // 开启且可见
    public static final int STATUS_CLOSE_SHOW = 2; // 关闭且可见
    public static final int STATUS_CLOSE = 3; // 关闭不可见
    public static final int STATUS_CLOSE_READY_ON = 4; // 关闭不可见，即将自动上架
    public static final String LIMITTYPEFOREVER = "forever"; // 永久
    public static final String LIMITTYPEEVERYDAY = "everyday"; // 每天
    //SWITCHES 开关
    public static final int SWITCHES_DIRECT = 0;//定向发放
    public static final int SWITCHES_DEV_BLACKLIST = 1;//黑名单
    public static final int SWITCHES_FREE_RULE = 2;// 免费次数使用的活动规则
    public static final int SWITCHES_NEW = 3;//判断是否是新添加的活动-与管理员端保持一样用3,新添加活动大奖默认开启库存预分配功能
    //public static final int SWITCHES_NEW_HDTOOL = 4;//判断是否是新的活动工具
    public static final int ANTICHEAT_LIMIT_RULE = 5; // 开启直充类奖品防刷
    public static final int SWITCHES_NEW_ABTEST = 6;//活动工具是否开启 ab test
    public static final int SWITCHES_NEW_OPEN_MUTLI_PRIZE_LIMIT = 7;//开启多奖项限制
    public static final int SWITCHES_PRIZES_GRANT_LIMIT = 8;//奖品发放限制
    public static final int SWITCHES_PRIZES_GUESS = 9;//竞猜是否开奖
    public static final int SWITCHES_ACTIVITY_GROUP = 10; //是否在活动组
    public static final int SWITCHES_DIRECT_SEND_COUPON = 11; //是否直接出券
    /** 奖项中是否包含集卡红包 */
    public static final int SWITCHES_HAS_BONUS_OPTIONS = 12;
    /**
     * 是否开启邀请码规则
     */
    public static final int SWITCHES_INVITATION_CODE_RULE = 13;
    public static final String TYPE_CUSTOM_ACTION = "custom";//自定义活动工具
    public static final String EXT_JSON_KEY_MUTLI_PRIZE_LIMIT_COUNT = "mutliPrizeLimitCount";//extendJson扩展json字段key定义：多奖项限制次数
    public static final String EXT_JSON_KEY_MUTLI_PRIZE_LIMIT_IDS = "mutliPrizeLimitIds";//extendJson扩展json字段key定义：多奖项限制id列表
    public static final String EXT_JSON_KEY_MULTI_PRIZE_LIMIT_TYPE = "multiPrizeLimitType";// extendJson扩展json字段key定义：多奖项限制次数周期类型：1，永久；2，每日；3，自定义周期
    public static final String EXT_JSON_KEY_MULTI_PRIZE_LIMIT_DAYS = "multiPrizeLimitDays";// extendJson扩展json字段key定义：多奖项限制次数自定义周期天数
    public static final String EXT_JSON_KEY_THROUGH_MODE = "through_mode";//extendJson扩展json字段key定义：闯关模式
    public static final String EXT_JSON_KEY_THROUGH_NUM = "through_num";//extendJson扩展json字段key定义：关卡数
    public static final String EXT_JSON_KEY_PRIZES_GRANT_LIMIT_DAYS = "prizesGrantLimitDays";//extendJson扩展json字段key定义：奖品兑换限制天数(旧版)
    public static final String EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NEW_DAYS = "prizesGrantLimitNewDays";//extendJson扩展json字段key定义：奖品兑换限制天数(新版)
    public static final String EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NUMS = "prizesGrantLimitNum";//extendJson扩展json字段key定义：各奖品兑换限制数量
    public static final String EXT_JSON_KEY_ANTI_CHEAT_EXCHANGE_TYPE = "anticheatExchangeType";//extendJson扩展json字段key定义：直冲类奖项防刷类型 0：每日一次  1：永久一次

    public static final int THROUGH_MODE = 1;//闯关模式
    public static final int THROUGH_MODE_FREE = 2;//自由模式
    public static final int THROUGH_MODE_CYCLE = 3;//单关循环

    //id
    private Long id;
    //标题
    private String title;
    //type
    private Integer type;
    //模版类型
    private String subType;
    //积分
    private Long creditsPrice;
    //免费抽奖次数
    private Integer freeLimit;
    //免费抽奖范围
    private String freeScope;
    //抽奖限制次数
    private Integer limitCount;
    //抽奖限制范围
    private String limitScope;
    //banner图
    private String bannerImage;
    //缩略图
    private String smallImage;
    //白底缩略图
    private String whiteImage;
    //图标
    private String logo;
    //黑名单开关
    private Long switches;
    //状态
    private Integer status;
    //删除状态
    private Boolean deleted;
    // 概率说明
    private String rateIntroduction;
    //定时自动下架日期
    private Date autoOffDate;
    //定时自动上架日期
    private Date autoOnDate;
    // 推荐位横幅图
    private String recommendImage;
    //免费次数参与的活动规则
    private String freeRule;
    //活动归类
    private Long activityCategoryId;
    //标签json
    private String tag;
    //json图片字符串
    private String imageJson;
    //皮肤id
    private Long duibaBrickId;
    //扩展字段1
    private String extendJson;
    //出奖方式
    private String factoryKey;
    //是否对开发者隐藏
    private Boolean hiddenForDeveloper;
    //加次数限制
    private Integer addTimeLimit;
    //新版首页banner
    protected String bannerImgNew;
    //新版缩略图
    protected String smallImgNew;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public Long getCreditsPrice() {
        return creditsPrice;
    }

    public void setCreditsPrice(Long creditsPrice) {
        this.creditsPrice = creditsPrice;
    }

    public Integer getFreeLimit() {
        return freeLimit;
    }

    public void setFreeLimit(Integer freeLimit) {
        this.freeLimit = freeLimit;
    }

    public String getFreeScope() {
        return freeScope;
    }

    public void setFreeScope(String freeScope) {
        this.freeScope = freeScope;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getWhiteImage() {
        return whiteImage;
    }

    public void setWhiteImage(String whiteImage) {
        this.whiteImage = whiteImage;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Long getSwitches() {
        return switches;
    }

    public void setSwitches(Long switches) {
        this.switches = switches;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getRateIntroduction() {
        return rateIntroduction;
    }

    public void setRateIntroduction(String rateIntroduction) {
        this.rateIntroduction = rateIntroduction;
    }

    public Date getAutoOffDate() {
        return autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    public Date getAutoOnDate() {
        return autoOnDate;
    }

    public void setAutoOnDate(Date autoOnDate) {
        this.autoOnDate = autoOnDate;
    }

    public String getRecommendImage() {
        return recommendImage;
    }

    public void setRecommendImage(String recommendImage) {
        this.recommendImage = recommendImage;
    }

    public String getFreeRule() {
        return freeRule;
    }

    public void setFreeRule(String freeRule) {
        this.freeRule = freeRule;
    }

    public Long getActivityCategoryId() {
        return activityCategoryId;
    }

    public void setActivityCategoryId(Long activityCategoryId) {
        this.activityCategoryId = activityCategoryId;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getImageJson() {
        if(StringUtils.isNotBlank(this.bannerImgNew) ||StringUtils.isNotBlank(this.smallImgNew)){
            //设置图片
            Map<String, String> keyMap = Maps.newHashMap();
            if(StringUtils.isNotBlank(this.bannerImgNew)){
                keyMap.put(BANNER_IMAGE_NEW.getCode(), this.bannerImgNew);
            }
            if(StringUtils.isNotBlank(this.smallImgNew)){
                keyMap.put(SMALL_IMAGE_NEW.getCode(), this.smallImgNew);
            }
            return JSON.toJSONString(keyMap);
        }
        return this.imageJson;
    }

    public void setImageJson(String imageJson) {
        this.imageJson = imageJson;
    }

    public Long getDuibaBrickId() {
        return duibaBrickId;
    }

    public void setDuibaBrickId(Long duibaBrickId) {
        this.duibaBrickId = duibaBrickId;
    }

    public String getExtendJson() {
        return extendJson;
    }

    public void setExtendJson(String extendJson) {
        this.extendJson = extendJson;
    }

    public String getFactoryKey() {
        return factoryKey;
    }

    public void setFactoryKey(String factoryKey) {
        this.factoryKey = factoryKey;
    }

    public Boolean getHiddenForDeveloper() {
        return hiddenForDeveloper;
    }

    public void setHiddenForDeveloper(Boolean hiddenForDeveloper) {
        this.hiddenForDeveloper = hiddenForDeveloper;
    }

    public Integer getAddTimeLimit() {
        return addTimeLimit;
    }

    public void setAddTimeLimit(Integer addTimeLimit) {
        this.addTimeLimit = addTimeLimit;
    }

    public String getBannerImgNew() {
        if (StringUtils.isNotBlank(this.imageJson)) {
            return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
            }).get(BANNER_IMAGE_NEW.getCode());
        }
        return StringUtils.EMPTY;
    }

    public void setBannerImgNew(String bannerImgNew) {
        this.bannerImgNew = bannerImgNew;
    }

    public String getSmallImgNew() {
        if (StringUtils.isNotBlank(this.imageJson)) {
            return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
            }).get(SMALL_IMAGE_NEW.getCode());
        }
        return StringUtils.EMPTY;
    }

    public void setSmallImgNew(String smallImgNew) {
        this.smallImgNew = smallImgNew;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 获取最新发奖限制天数
     * 兼容旧版本1每日,7自然周,30自然月
     * 改成天数：>0数字；自然周：-1；自然月：-2
     * 之前没设置好，流下了悔恨的泪水，过度后可删除
     * @param jsonObject
     * @return
     */
    public static Integer changeLimitDays2New (JSONObject jsonObject){
        if(jsonObject.get(DuibaHdtoolDto.EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NEW_DAYS)!=null){
            return jsonObject.getInteger(DuibaHdtoolDto.EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NEW_DAYS);
        }

        //旧版发奖限制天数(1每日,7每周,30每月)
        Integer prizesGrantLimitDays = jsonObject.getInteger(DuibaHdtoolDto.EXT_JSON_KEY_PRIZES_GRANT_LIMIT_DAYS);
        if(Objects.equals(prizesGrantLimitDays,7)){
            return -1;
        }else if(Objects.equals(prizesGrantLimitDays,30)){
            return -2;
        }
        return prizesGrantLimitDays;
    }
}