package cn.com.duiba.hdtool.center.api.dto.order;

import cn.com.duiba.dcommons.enums.ItemTypeEnums;

import java.io.Serializable;

/**
 * ClassName:HdtoolOrdersDto<br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2018/3/23  11:00
 * @since JDK 1.8
 **/
public class HdtoolOrdersDto implements Serializable{

    private static final long serialVersionUID = 945353515152636060L;
    public static final String PREFIX_ORDER = "hdtool-";

    public static final String PRIZE_TYPE_VIRTUAL = ItemTypeEnums.TypeVirtual.getName();       //虚拟商品
    public static final String PRIZE_TYPE_ALIPAY = ItemTypeEnums.TypeAlipay.getName(); 		// 支付宝
    public static final String PRIZE_TYPE_QB = ItemTypeEnums.TypeQB.getName();					// QB
    public static final String PRIZE_TYPE_COUPON = ItemTypeEnums.TypeCoupon.getName();			// 优惠劵
    public static final String PRIZE_TYPE_OBJECT = ItemTypeEnums.TypeObject.getName();			// 实物
    public static final String PRIZE_TYPE_PHONEBILL = ItemTypeEnums.TypePhonebill.getName();	// 话费
    public static final String PRIZE_TYPE_THANKS = "thanks";					// 谢谢参与
    public static final String PRIZE_TYPE_AGAIN = "again"; 					// 再来一次
    public static final String PRIZE_TYPE_LUCKBAG = "lucky";                  // 福袋
    public static final String PRIZE_TYPE_COLLECTGOODS = "collectGoods";      // 集卡

    public static final int EXCHANGE_STATUS_CREATE = 0;	// 创建
    public static final int EXCHANGE_STATUS_WAIT = 1;		// 待领取
    public static final int EXCHANGE_STATUS_SUCCESS = 2; 	// 领奖成功
    public static final int EXCHANGE_STATUS_FAIL = 3;		// 领奖失败，可以再次尝试
    public static final int EXCHANGE_STATUS_OVERDUE = 4;	// 未领取，过期

    public static final int STATUS_CREATE = 0; 		// 处理中
    public static final int STATUS_SUCCESS = 1;		// 处理成功
    public static final int STATUS_FAIL = 2;			// 处理失败

    private Long id;
    private Integer status;//状态
    private Long appId;//appid
    private Long consumerId;//用户id
    private String partnerUserId;//用户uid
    private Long operatingActivityId;//入库活动id
    private Long duibaHdtoolId;//duiba活动id
    private Integer hdtoolType;//活动类型
    private Long prizeId;//奖品id
    private String prizeName;//奖品名称
    private Long appItemId;//app兑换项id
    private Long itemId;//兑换项id
    private Long couponId;//优惠券id
    private String facePrice;//实际价格
    private Long credits;//积分
    private String prizeType;//奖品类型
    private Integer exchangeStatus;//交易状态
    private Long sourceOrderId;
    private Long mainOrderId;//主订单id
    private String mainOrderNum;//主订单号
    private String developerBizId;//开发者业务id
    private String error4Admin;
    private String error4Developer;
    private String error4Consumer;
    private String ip;
    //当虚拟商品需要用户输入账号的时候，用于临时存储用户输入的用户名
    private String username;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Long getDuibaHdtoolId() {
        return duibaHdtoolId;
    }

    public void setDuibaHdtoolId(Long duibaHdtoolId) {
        this.duibaHdtoolId = duibaHdtoolId;
    }

    public Integer getHdtoolType() {
        return hdtoolType;
    }

    public void setHdtoolType(Integer hdtoolType) {
        this.hdtoolType = hdtoolType;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public String getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(String facePrice) {
        this.facePrice = facePrice;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public Integer getExchangeStatus() {
        return exchangeStatus;
    }

    public void setExchangeStatus(Integer exchangeStatus) {
        this.exchangeStatus = exchangeStatus;
    }

    public Long getSourceOrderId() {
        return sourceOrderId;
    }

    public void setSourceOrderId(Long sourceOrderId) {
        this.sourceOrderId = sourceOrderId;
    }

    public Long getMainOrderId() {
        return mainOrderId;
    }

    public void setMainOrderId(Long mainOrderId) {
        this.mainOrderId = mainOrderId;
    }

    public String getMainOrderNum() {
        return mainOrderNum;
    }

    public void setMainOrderNum(String mainOrderNum) {
        this.mainOrderNum = mainOrderNum;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public String getError4Admin() {
        return error4Admin;
    }

    public void setError4Admin(String error4Admin) {
        String error4AdminNew=error4Admin;
        if(error4Admin!=null&&error4Admin.length()>250){
            error4AdminNew = error4Admin.substring(0,250);
        }
        this.error4Admin = error4AdminNew;
    }

    public String getError4Developer() {
        return error4Developer;
    }

    public void setError4Developer(String error4Developer) {
        String error4DeveloperNew=error4Developer;
        if(error4Developer!=null&&error4Developer.length()>250){
            error4DeveloperNew = error4Developer.substring(0,250);
        }
        this.error4Developer = error4DeveloperNew;
    }

    public String getError4Consumer() {
        return error4Consumer;
    }

    public void setError4Consumer(String error4Consumer) {
        String error4ConsumerNew=error4Consumer;
        if(error4Consumer!=null&&error4Consumer.length()>250){
            error4ConsumerNew = error4Consumer.substring(0,250);
        }
        this.error4Consumer = error4ConsumerNew;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public static synchronized String generateOrderNum(Long id) {
        return PREFIX_ORDER + id.toString();
    }
}
