package cn.com.duiba.hdtool.center.api.params;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author fja
 */
public class HdtoolHelperParam implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 应用id
     */
    private Long appId;
    /**
     * 兑吧用户id
     */
    private Long consumerId;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 页码
     */
    private Integer pageNum;
    /**
     * 每页数据量
     */
    private Integer pageSize;
    /**
     * 分页偏移量
     */
    private Integer offset;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        if (Objects.nonNull(pageNum) && Objects.nonNull(pageSize)) {
            return (pageNum - 1) * pageSize;
        }
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }
}
