package cn.com.duiba.hdtool.center.api.remoteservice.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.question.DuibaQuestionBankDto;
import cn.com.duiba.hdtool.center.api.dto.question.DuibaQuestionRecordDto;

import java.util.List;

/**
 * ClassName:RemoteDuibaQuestionBackendService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 兑吧答题题库 管理端接口
 * @date 创建时间：2018/4/8  17:32
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteDuibaQuestionBackendService {
    /**
     *
     * findBankAll:(查询所有题库). <br/>
     *
     * @return
     * @since JDK 1.8
     */
    public List<DuibaQuestionBankDto> findBankAll();

    /**
     *
     * findBankByPage:(题库列表页). <br/>
     *
     * @param offset
     * @param max
     * @return
     * @since JDK 1.8
     */
    public List<DuibaQuestionBankDto> findBankByPage(Integer offset, Integer max);

    /**
     *
     * findBankTotalCount:(题库列表总条数). <br/>
     *
     * @return
     * @since JDK 1.8
     */
    public Long findBankTotalCount();

    /**
     *
     * saveOrUpdateBank:(插入或者更新题库). <br/>
     *
     * @param dto
     * @return
     * @since JDK 1.8
     */
    public DuibaQuestionBankDto saveOrUpdateBank(DuibaQuestionBankDto dto);

    /**
     *
     * deleteBankById:(删除题库). <br/>
     *
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Integer deleteBankById(Long id);


    /**
     *
     * findQuestionTotalCount:(查询题库下所有题目总数). <br/>
     *
     * @param questionBankId
     * @return
     * @since JDK 1.8
     */
    public Long findQuestionTotalCount(Long questionBankId);

    /**
     *
     * findBankByPage:(查询题库下所有题目). <br/>
     *
     * @param questionBankId
     * @param offset
     * @param max
     * @return
     * @since JDK 1.8
     */
    public List<DuibaQuestionRecordDto> findQuestionAll(Long questionBankId, Integer offset, Integer max);

    /**
     * findByIds:(根据题目id列表查询题目信息). <br/>
     * @param ids
     * @return
     * @throws BizException
     */
    public List<DuibaQuestionRecordDto> findByIds(List <Long> ids) throws BizException;

    /**
     *
     * saveOrUpdateQuestion:(插入或者更新题目). <br/>
     *
     * @param dto
     * @return
     * @since JDK 1.8
     */
    public DuibaQuestionRecordDto saveOrUpdateQuestion(DuibaQuestionRecordDto dto) throws BizException;


    /**
     * 批量插入
     *
     * @param dto
     * @return
     * @throws BizException
     */
    public List<DuibaQuestionRecordDto> batchInsert(List<DuibaQuestionRecordDto> dto);

    /**
     *
     * deleteQuestionById:(这里用一句话描述这个方法的作用). <br/>
     * 删除题库的一个题目
     * @param id
     * @since JDK 1.8
     */
    public Integer deleteQuestionById(Long id);
}