package cn.com.duiba.hdtool.center.api.dto.lottery;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * ClassName:LotteryBetDto<br/>
 * 博彩投注活动
 *
 * @author xukaiqiang
 * @version 1.0
 * @date 创建时间：2018/05/29  13:38
 * @since JDK 1.8
 **/
public class LotteryBetDto implements Serializable {

    private static final long serialVersionUID = -4803201574295291374L;

    //主键自增
    private Long id;

    //活动名称（用于管理端的名称显示）
    private String title;

    //活动标题（用于显示在手机端的活动标题）
    private String betName;

    //投注开始时间
    private Date beginTime;

    //投注结束时间
    private Date endTime;

    //结算状态：0，未结算；1，开奖；2，退单
    private Integer betStatus;

    //参与方式：1，自由投注；2，固定值
    private Integer betType;

    //如果参与方式是自由投注，则为用户最高总投注积分；如果参与方式是固定值，则为指定投注积分
    private Long limitCredits;

    //是否可追加：0，否；1，是
    private Integer canAdd;

    //投注结果选项id
    private Long betResult;

    //投注结果说明
    private String betResultDesc;

    //是否删除：0，否；1，是
    private Integer deleted;

    private List<LotteryBetItemDto> lotteryBetItems;

    //总计投注分数
    private Long totalBetCredits;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBetName() {
        return betName;
    }

    public void setBetName(String betName) {
        this.betName = betName;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getBetStatus() {
        return betStatus;
    }

    public void setBetStatus(Integer betStatus) {
        this.betStatus = betStatus;
    }

    public Integer getBetType() {
        return betType;
    }

    public void setBetType(Integer betType) {
        this.betType = betType;
    }

    public Long getLimitCredits() {
        return limitCredits;
    }

    public void setLimitCredits(Long limitCredits) {
        this.limitCredits = limitCredits;
    }

    public Integer getCanAdd() {
        return canAdd;
    }

    public void setCanAdd(Integer canAdd) {
        this.canAdd = canAdd;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public List<LotteryBetItemDto> getLotteryBetItems() {
        return lotteryBetItems;
    }

    public void setLotteryBetItems(List<LotteryBetItemDto> lotteryBetItems) {
        this.lotteryBetItems = lotteryBetItems;
    }

    public Long getTotalBetCredits() {
        return totalBetCredits;
    }

    public void setTotalBetCredits(Long totalBetCredits) {
        this.totalBetCredits = totalBetCredits;
    }

    public Long getBetResult() {
        return betResult;
    }

    public void setBetResult(Long betResult) {
        this.betResult = betResult;
    }

    public String getBetResultDesc() {
        return betResultDesc;
    }

    public void setBetResultDesc(String betResultDesc) {
        this.betResultDesc = betResultDesc;
    }
}
