package cn.com.duiba.hdtool.center.api.enums;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * ClassName:ActivityDataTypeEnum<br/>
 *
 * @author gey
 *
 * @version 1.0
 *
 * @Description: 活动工具出奖方式
 *
 * @date 创建时间：2018/3/9  19:17
 *
 * @since JDK 1.8
 **/
public enum ActivityDataTypeEnum {
	
	ACTIVITY_TOOL("hdtool","概率出奖",false),
	QUESTION_ANSWER("question","答题活动-题目数出奖",true),
	QUESTION_ANSWER_HDTOOL("qhdtool","答题活动-概率出奖",true),
	GAME_TOOL("game","游戏前置开奖",false),
	THROUGH("through","闯关游戏",true),
	LOTTERY_BET("lotterybet","博彩投注",false);
	
	//后续操作key
	private String key;
	//名称
	private String name;
	//是否执行 后续操作  true 不执行，false 执行
	private boolean executeFlag;

	private static Map<String,ActivityDataTypeEnum> typeMap = Maps.newHashMap();

	private static List<ActivityDataTypeEnum> list =Lists.newArrayList();
	
	ActivityDataTypeEnum(String key,String name,boolean executeFlag){
		this.name = name;
		this.key = key;
		this.executeFlag = executeFlag;
	}

	public String getKey() {
		return key;
	}

	public String getName() {
		return name;
	}

	public boolean isExecuteFlag() {
		return executeFlag;
	}

	static{
		for(ActivityDataTypeEnum typeClass : ActivityDataTypeEnum.values()){
			typeMap.put(typeClass.getKey(),typeClass);
			list.add(typeClass);
		}
	}

	/**
	 * 根据type获取具体枚举类型
	 * @param key
	 * @return
	 */
	public static ActivityDataTypeEnum getByType(String key){
		return typeMap.get(key);
	}
	
	/**
	 * 获取全部 枚举值和名称
	 * @return
	 */
	public static List<ActivityDataTypeEnum> getAll(){
		return list;
	}
}
