package cn.com.duiba.hdtool.center.api.remoteservice.hdtool;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.hdtool.HdtoolSkinDto;

/**
 * ClassName:RemoteHdtoolSkinDataService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 活动工具皮肤数据
 * @date 创建时间：2018/3/16  10:08
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteHdtoolSkinDataService {
    /**
     *
     * createHdtoolSkinData:(这里用一句话描述这个方法的作用). <br/>
     * 开发者/兑吧编辑活动模版定制后，创建一条模版数据
     * @param hdtoolSkinDto
     * @return
     * @since JDK 1.8
     */
    public HdtoolSkinDto createHdtoolSkinData(HdtoolSkinDto hdtoolSkinDto);

    /**
     *
     * createHdtoolSkinData:(这里用一句话描述这个方法的作用). <br/>
     * 开发者/兑吧编辑活动模版定制后，更新一条模版数据
     * @param hdtoolSkinDto
     * @return
     * @since JDK 1.8
     */
    public Integer updateHdtoolSkinData(HdtoolSkinDto hdtoolSkinDto);

    /**
     * 查询活动Json数据
     * @author zp
     * @param hdtoolId
     * @param type
     * @param appId
     * @return
     * @since JDK 1.8
     */
    public String querySkin(Long hdtoolId, String type,Long appId) throws BizException;

    /**
     * 查询活动自定义配置数据
     * @author zp
     * @param hdtoolId
     * @param type
     * @param appId
     * @return
     * @since JDK 1.8
     */
    public HdtoolSkinDto queryHdtoolBaseSkin(Long hdtoolId, String type,Long appId)throws BizException;
}
