package cn.com.duiba.hdtool.center.api.remoteservice.hdtool;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.hdtool.center.api.params.HdtoolParam;

import java.util.List;

/**
 * ClassName:RemoteDuibaHdtoolBackendService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 活动工具配置查询  管理后台，开发者使用 无缓存 不使用手机端
 * @date 创建时间：2018/3/15  10:13
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteDuibaHdtoolBackendService {
    /**
     * @Description: 根据条件查询 活动工具信息
     *
     * @param param
     *
     * @author gey
     *
     * @date 2018/3/9 17:35
     */
    public List<DuibaHdtoolDto> findDuibaHdToolsList(HdtoolParam param);

    /**
     *
     * @Description: 统计活动工具条数
     *
     * @param param
     * @return
     * @since JDK 1.8
     */
    public Integer countDuibaHdToolsList(HdtoolParam param);

    /**
     *
     * @Description:  新增或者更新兑吧活动工具
     *
     * @param duibaHdtoolDto
     *
     * @return
     *
     * @since JDK 1.8
     */
    public DuibaHdtoolDto insertOrUpdate(DuibaHdtoolDto duibaHdtoolDto);

    /**
     *
     * @Description: 删除兑吧活动
     *
     * @param id
     *
     * @return
     *
     * @since JDK 1.8
     */
    public Integer deleteById(Long id);

    /**
     *
     * @Description:  修改活动工具状态
     *
     * @param id
     * @param status
     *
     * @return
     *
     * @since JDK 1.8
     */
    public Integer updateStatus(Long id, Integer status);


    /**
     * @Description:  自动开始时间 自动下架时间清空
     *
     * @param id
     * @param  status  1:自动开始时间  2：自动下架时间
     * @param  extendJson
     *
     * @return
     */
    public void updateAutoDateNull(Long id,Integer status,String extendJson);

    /**
     * 活动工具自动上架
     * @return
     */
    public List<Long> autoOnHdTool();

    /**
     * 查询一天内，需要定时下架的活动工具
     * @return
     */
    public List<DuibaHdtoolDto> findAutoOff();

    /**
     * 批量更新switches 最多一次40条
     * @param duibaHdtoolDtoList duibaHdtoolDtoList
     * @return 成功数
     * @throws BizException bizException
     */
    Integer batchUpdateSwitch(List<DuibaHdtoolDto> duibaHdtoolDtoList) throws BizException;

    /**
     * 后台根据活动编号查询活动
     * @return
     */
    DuibaHdtoolDto getDataFromDb(Long id) throws BizException;
}
