package cn.com.duiba.hdtool.center.api.remoteservice.hdtool;

import cn.com.duiba.biz.tool.duiba.dto.BizResultDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.hdtool.SpecifyConfigDto;

import java.util.List;

/**
 * ClassName:RemoteSpecifyConfigBackendService.java <br/>
 * 管理端接口
 * 开发者定向配置
 *
 * @author xukaiqiang
 * @version 1.0
 * @date 创建时间：2018年05月23日 14:17
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteSpecifyConfigBackendService {

    /**
     * @param id
     * @Description: 根据活动id 查询APP配置信息
     */
    BizResultDto<List<SpecifyConfigDto>> listByActivityId(Long id);

    /**
     * @param list
     * @Description: 批量插入APP配置信息
     */
    BizResultDto insertBatch(List<SpecifyConfigDto> list);

    /**
     * @param specifyConfigDto
     * @Description: 根据配置信息编号编辑
     */
    BizResultDto update(SpecifyConfigDto specifyConfigDto);

    /**
     * @param id
     * @Description: 根据配置信息编号删除
     */
    BizResultDto delete(Long id);

}
